'Word Search
option base 1
dim string w$ length 100 '20
dim string word$(117561) length 20
dim string wordlist$(800) length 20
dim string grid$(160, 105) length 1
dim string score1$ length 1, score2$ length 1, score3$ length 1
dim integer h, i, j, r, z, rd, rx, ry, gsx, gsy, endx, endy, num_words, score
dim integer sx, sy, cx, cy, ocx, ocy, cw, ch, csx, csy, cox, coy
dim integer size, dsize 'font size and dictionary size
dim integer type '1 = user sees a word list, 2 = user sees blank word list initially,
                 'then words appear there when found, 3 = nearly whole screen is grid of letters
dim integer gridstate(160, 105) '0 = green letters, 1 = white letters (found), 2 = LOCKED, white letters
dim integer gridhit(160, 105, 4) '0 = letter is NOT part of a selected word
                                 'last dimension allows up to four words to crisscross the letter
dim integer letter_count, dat_file_bytes, byte_selected, ghc 'grid hit count
mode 15, 8 '1280x1024  'mode 9, 8
font 5 '24x32   '12x20
color rgb(green)
main()

sub main
  cls
  color rgb(white)
  text 24,  0, "Word Search"
  color rgb(cyan)
  text 24,  64, "1. 32 x 48"
  text 24,  96, "2. 24 x 32"
  text 24, 128, "3. 16 x 24"
  text 24, 160, "4. 12 x 20"
  text 24, 192, "5. 10 x 16"
  text 24, 224, "6.  8 x 12"
  text 24, 256, "7.  6 x  8"
  text 24, 320, "Which size font"
  do
    text 24, 352, "" : input size
    if size < 1 or size > 7 then continue do
    exit do
  loop
  color rgb(orange)
  text 24, 416, "1. Display a word list"
  text 24, 448, "2. Hide word list initially"
  text 24, 480, "3. No word list"
  text 24, 544, "Which type"
  do
    text 24, 576, "" : input type   
    if type < 1 or type > 3 then continue do
    exit do
  loop
  color rgb(green)
  text 24, 640, "1. Unabridged (334,070 words)" 
  text 24, 672, "2. Collegiate (117,561 words)"
  text 24, 704, "3. Scowl 50 US (72,299 words)"
  text 24, 736, "4. High School (58,106 words)"
  text 24, 768, "5. Scowl 35 US (39,488 words)"
  text 24, 800, "6. Scowl 20 US (10,956 words)"
  text 24, 832, "7. Scowl 10 US  (4,006 words)"
  text 24, 896, "Which size dictionary"
  do
    text 24, 928, "" : input dsize
    if dsize < 1 or dsize > 7 then continue do
    exit do
  loop
  cls

  if size = 1 and type <> 3 then
    gsx = 19 : gsy = 21 : num_words = 19 : font 3, 2 : fo = 3 '32x48
  elseif size = 2 and type <> 3 then
    gsx = 30 : gsy = 31 : num_words = 30 : font 5 : fo = 5 '24x32
  elseif size = 3 and type <> 3 then
    gsx = 49 : gsy = 42 : num_words = 40 : font 3 : fo = 3 '16x24
  elseif size = 4 and type <> 3 then
    gsx = 55 : gsy = 46 : num_words = 98 : font 2 : fo = 2 '12x20
  elseif size = 5 and type <> 3 then
    gsx = 70 : gsy = 60 : num_words = 126 : font 4 : fo = 4 '10x16
  elseif size = 6 and type <> 3 then
    gsx = 83 : gsy = 68 : num_words = 166 : font 1 : fo = 1 '8x12
  elseif size = 7 and type <> 3 then
    gsx = 109 : gsy = 102 : num_words = 378 : font 7 : fo = 7 '6x8  
  elseif size = 1 and type = 3 then
    gsx = 36 : gsy = 21 : num_words = 48 : font 3, 2 : fo = 3
  elseif size = 2 and type = 3 then
    gsx = 48 : gsy = 31 : num_words = 72 : font 5 : fo = 5
  elseif size = 3 and type = 3 then
    gsx = 66 : gsy = 42 : num_words = 120 : font 3 : fo = 3
  elseif size = 4 and type = 3 then
    gsx = 90 : gsy = 46 : num_words = 200 : font 2 : fo = 2
  elseif size = 5 and type = 3 then
    gsx = 105 : gsy = 60 : num_words = 360 : font 4 : fo = 4
  elseif size = 6 and type = 3 then
    gsx = 115 : gsy = 68 : num_words = 520 : font 1 : fo = 1
  elseif size = 7 and type = 3 then
    gsx = 158 : gsy = 102 : num_words = 800 : font 7 : fo = 7
  endif

  select case dsize
    case 1
      open "Unabridged 40 334070.dat" for random as #1
      dat_file_bytes = mm.info(filesize "Unabridged 40 334070.dat")
      for i = 1 to num_words
        do
          byte_selected = int(rnd * dat_file_bytes + 1)
          if byte_selected + 40 > dat_file_bytes then inc byte_selected, -40
          seek #1, byte_selected
          line input #1, w$
          w$ = ""
          line input #1, w$
          if len(w$) < 3 then continue do
          if size = 1 and len(w$) > 19 then continue do
          if len(w$) > 20 then continue do
          for j = 1 to len(w$) 
            if mid$(lcase$(w$), j, 1) < chr$(97) or mid$(lcase$(w$), j, 1) > chr$(122) then
              continue do
            endif 
          next j
          exit do
        loop
        word$(i) = w$
      next i
    case 2
      open "Collegiate 20 117561.dat" for input as #1
      for i = 1 to 117561
    case 3
      open "Scowl 50 US 72299.dat" for input as #1
      for i = 1 to 72299
    case 4
      open "Fourth 58106.dat" for input as #1
      for i = 1 to 58106
    case 5
      open "Scowl 35 US 39488.dat" for input as #1
      for i = 1 to 39488
    case 6
      open "Scowl 20 US 10956.dat" for input as #1
      for i = 1 to 10956
    case 7
      open "Scowl 10 US 4006.dat" for input as #1
      for i = 1 to 4006
  end select
  if dsize > 1 then
    line input #1, w$
    word$(i) = w$ 
    next i
    close #1
  endif
  if type = 3 then
    score = 0 : score1$ = "" : score2$ = "" : score3$ = ""
  else 'type <> 3
    score = num_words
  endif  

  'Initialize arrays
  for i = 1 to 800
    wordlist$(i) = "" 
  next i
  for i = 1 to 160
    for j = 1 to 105
      grid$(i, j) = ""
      gridstate(i, j) = 0  
      gridhit(i, j, 1) = 0
      gridhit(i, j, 2) = 0
      gridhit(i, j, 3) = 0
      gridhit(i, j, 4) = 0
    next j
  next i
  
  for i = 1 to num_words  
    'Select a random word from word array and place it in wordlist array
    if dsize > 1 then
      do
        select case dsize
          case 2
            r = int(rnd * 117561 + 1)
          case 3
            r = int(rnd * 72299 + 1)
          case 4
            r = int(rnd * 58106 + 1)
          case 5
            r = int(rnd * 39488 + 1)
          case 6
            r = int(rnd * 10956 + 1)
          case 7
            r = int(rnd * 4006 + 1)
        end select
        if len(word$(r)) < 3 then continue do
        if size = 1 and len(word$(r)) > 19 then continue do
        if len(word$(r)) > 20 then continue do
        for j = 1 to len(word$(r))
          'chr$(97) = "a", chr$(122) = "z"
          if mid$(lcase$(word$(r)), j, 1) < chr$(97) or mid$(lcase$(word$(r)), j, 1) > chr$(122) then
            continue do
          endif 
        next j
        wordlist$(i) = ucase$(word$(r))
        exit do
      loop
    else 'dsize = 1
      wordlist$(i) = ucase$(word$(i)) 
    endif
  next i
  
  'Place words from wordlist into grid
  for i = 1 to num_words
    do
      rx = int(rnd * gsx + 1) : ry = int(rnd * gsy + 1) : rd = int(rnd * 8 + 1)
      select case rd '8 directions
        case 1 : endx = rx + len(wordlist$(i)) - 1 : endy = ry + len(wordlist$(i)) - 1
        case 2 : endx = rx + len(wordlist$(i)) - 1 : endy = ry - len(wordlist$(i)) - 1
        case 3 : endx = rx - len(wordlist$(i)) - 1 : endy = ry + len(wordlist$(i)) - 1
        case 4 : endx = rx - len(wordlist$(i)) - 1 : endy = ry - len(wordlist$(i)) - 1
        case 5 : endx = rx + len(wordlist$(i)) - 1 : endy = ry
        case 6 : endx = rx - len(wordlist$(i)) - 1 : endy = ry
        case 7 : endx = rx : endy = ry + len(wordlist$(i)) - 1
        case 8 : endx = rx : endy = ry - len(wordlist$(i)) - 1
      end select
      
      'Check to see if the selected location fits on the grid and is not yet filled with letters
      if endx < 1 or endx > gsx or endy < 1 or endy > gsy then
        continue do
      endif
      'Allow words to crisscross/overlap
      for j = 1 to len(wordlist$(i)) 
        select case rd
          case 1
            if grid$(rx + j - 1, ry + j - 1) <> "" then
              if grid$(rx + j - 1, ry + j - 1) <> mid$(wordlist$(i), j, 1) then 
                continue do
               endif
            endif
          case 2
            if grid$(rx + j - 1, ry - j - 1) <> "" then
              if grid$(rx + j - 1, ry - j - 1) <> mid$(wordlist$(i), j, 1) then
                continue do
              endif
            endif
          case 3
            if grid$(rx - j - 1, ry + j - 1) <> "" then
              if grid$(rx - j - 1, ry + j - 1) <> mid$(wordlist$(i), j, 1) then
                continue do
              endif
            endif
          case 4
            if grid$(rx - j - 1, ry - j - 1) <> "" then
              if grid$(rx - j - 1, ry - j - 1) <> mid$(wordlist$(i), j, 1) then
                continue do
              endif
            endif
          case 5
            if grid$(rx + j - 1, ry) <> "" then
              if grid$(rx + j - 1, ry) <> mid$(wordlist$(i), j, 1) then
                continue do
              endif
            endif
          case 6
            if grid$(rx - j - 1, ry) <> "" then
              if grid$(rx - j - 1, ry) <> mid$(wordlist$(i), j, 1) then
                continue do
              endif
            endif
          case 7
            if grid$(rx, ry + j - 1) <> "" then
              if grid$(rx, ry + j - 1) <> mid$(wordlist$(i), j, 1) then
                continue do
              endif
            endif
          case 8
            if grid$(rx, ry - j - 1) <> "" then
              if grid$(rx, ry - j - 1) <> mid$(wordlist$(i), j, 1) then
                continue do
              endif
            endif
        end select
      next j

      'Copy the letters from the words in the wordlist to the grid
      for j = 1 to len(wordlist$(i))
        select case rd
          case 1 
            grid$(rx + j - 1, ry + j - 1) = mid$(ucase$(wordlist$(i)), j, 1)    
            if gridhit(rx + j - 1, ry + j - 1, 1) = 0 then
              gridhit(rx + j - 1, ry + j - 1, 1) = i    
            elseif gridhit(rx + j - 1, ry + j - 1, 2) = 0 then
              gridhit(rx + j - 1, ry + j - 1, 2) = i
            elseif gridhit(rx + j - 1, ry + j - 1, 3) = 0 then
              gridhit(rx + j - 1, ry + j - 1, 3) = i
            else
              gridhit(rx + j - 1, ry + j - 1, 4) = i
            endif
          case 2
            grid$(rx + j - 1, ry - j - 1) = mid$(ucase$(wordlist$(i)), j, 1)
            if gridhit(rx + j - 1, ry - j - 1, 1) = 0 then
              gridhit(rx + j - 1, ry - j - 1, 1) = i
            elseif gridhit(rx + j - 1, ry - j - 1, 2) = 0 then
              gridhit(rx + j - 1, ry - j - 1, 2) = i
            elseif gridhit(rx + j - 1, ry - j - 1, 3) = 0 then
              gridhit(rx + j - 1, ry - j - 1, 3) = i
            else
              gridhit(rx + j - 1, ry - j - 1, 4) = i
            endif
          case 3 
            grid$(rx - j - 1, ry + j - 1) = mid$(ucase$(wordlist$(i)), j, 1)    
            if gridhit(rx - j - 1, ry + j - 1, 1) = 0 then
              gridhit(rx - j - 1, ry + j - 1, 1) = i
            elseif gridhit(rx - j - 1, ry + j - 1, 2) = 0 then
              gridhit(rx - j - 1, ry + j - 1, 2) = i
            elseif gridhit(rx - j - 1, ry + j - 1, 3) = 0 then
              gridhit(rx - j - 1, ry + j - 1, 3) = i
            else
              gridhit(rx - j - 1, ry + j - 1, 4) = i
            endif
          case 4
            grid$(rx - j - 1, ry - j - 1) = mid$(ucase$(wordlist$(i)), j, 1)
            if gridhit(rx - j - 1, ry - j - 1, 1) = 0 then 
              gridhit(rx - j - 1, ry - j - 1, 1) = i
            elseif gridhit(rx - j - 1, ry - j - 1, 2) = 0 then 
              gridhit(rx - j - 1, ry - j - 1, 2) = i 
            elseif gridhit(rx - j - 1, ry - j - 1, 3) = 0 then 
              gridhit(rx - j - 1, ry - j - 1, 3) = i
            else
              gridhit(rx - j - 1, ry - j - 1, 4) = i
            endif
          case 5 
            grid$(rx + j - 1, ry) = mid$(ucase$(wordlist$(i)), j, 1) 
            if gridhit(rx + j - 1, ry, 1) = 0 then
              gridhit(rx + j - 1, ry, 1) = i
            elseif gridhit(rx + j - 1, ry, 2) = 0 then
              gridhit(rx + j - 1, ry, 2) = i
            elseif gridhit(rx + j - 1, ry, 3) = 0 then
              gridhit(rx + j - 1, ry, 3) = i
            else
              gridhit(rx + j - 1, ry, 4) = i
            endif
          case 6
            grid$(rx - j - 1, ry) = mid$(ucase$(wordlist$(i)), j, 1)
            if gridhit(rx - j - 1, ry, 1) = 0 then
              gridhit(rx - j - 1, ry, 1) = i
            elseif gridhit(rx - j - 1, ry, 2) = 0 then
              gridhit(rx - j - 1, ry, 2) = i  
            elseif gridhit(rx - j - 1, ry, 3) = 0 then
              gridhit(rx - j - 1, ry, 3) = i 
            else
              gridhit(rx - j - 1, ry, 4) = i
            endif
          case 7 
            grid$(rx, ry + j - 1) = mid$(ucase$(wordlist$(i)), j, 1)    
            if gridhit(rx, ry + j - 1, 1) = 0 then
              gridhit(rx, ry + j - 1, 1) = i
            elseif gridhit(rx, ry + j - 1, 2) = 0 then
              gridhit(rx, ry + j - 1, 2) = i
            elseif gridhit(rx, ry + j - 1, 3) = 0 then
              gridhit(rx, ry + j - 1, 3) = i
            else
              gridhit(rx, ry + j - 1, 4) = i
            endif
          case 8
            grid$(rx, ry - j - 1) = mid$(ucase$(wordlist$(i)), j, 1)
            if gridhit(rx, ry - j - 1, 1) = 0 then
              gridhit(rx, ry - j - 1, 1) = i
            elseif gridhit(rx, ry - j - 1, 2) = 0 then
              gridhit(rx, ry - j - 1, 2) = i
            elseif gridhit(rx, ry - j - 1, 3) = 0 then
              gridhit(rx, ry - j - 1, 3) = i
            else
              gridhit(rx, ry - j - 1, 4) = i
            endif
        end select
      next j 
      exit do
    loop
  next i    

  'Fill the empty grid locations with random letters      
  for i = 1 to gsx
    for j = 1 to gsy
      if grid$(i, j) = "" then 
        r = int(rnd * 26 + 1)
        grid$(i, j) = chr$(64 + r) 'chr$(65) = "A", chr$(90) = "Z"
      endif
    next j
  next i

  'Display grid
  for i = 1 to gsx
    for j = 1 to gsy  
      select case size
        case 1
          cox = 34 : coy = 49: sx = 1 : sy = 3
          text cox * (i - 1) + sx, coy * (j - 1) + sy, grid$(i, j),, 3, 2, rgb(green), rgb(black) 
        case 2
          cox = 26 : coy = 33: sx = 1 : sy = 3
          text cox * (i - 1) + sx, coy * (j - 1) + sy, grid$(i, j),, 5,, rgb(green), rgb(black) 
        case 3
          cox = 19 : coy = 24 : sx = 1 : sy = 1
          text cox * (i - 1) + sx, coy * (j - 1) + sy, grid$(i, j),, 3,, rgb(green), rgb(black) 
        case 4
          cox = 14 : coy = 22 : sx = 2 : sy = 1
          text cox * (i - 1) + sx, coy * (j - 1) + sy, grid$(i, j),, 2,, rgb(green), rgb(black) 
        case 5
          cox = 12 : coy = 17 : sx = 2 : sy = 3
          text cox * (i - 1) + sx, coy * (j - 1) + sy, grid$(i, j),, 4,, rgb(green), rgb(black) 
        case 6
          cox = 11 : coy = 15 : sx = 3 : sy = 6
          text cox * (i - 1) + sx, coy * (j - 1) + sy, grid$(i, j),, 1,, rgb(green), rgb(black) 
        case 7
          cox = 8 : coy = 10 : sx = 1 : sy = 0
          text cox * (i - 1) + sx + 1, coy * (j - 1) + sy + 1, grid$(i, j),, 7,, rgb(green), rgb(black) 
      end select
    next j
  next i

  display_score()

  'Display word list
  select case size
    case 1
      if type <> 3 then
        text 672, 3, "Word List " + str$(score) + " of " + str$(num_words),, 3, 2, rgb(white)
      endif
      if type = 1 then
        for i = 1 to num_words
          text 672, 48 * (i +  1), wordlist$(i),, 3, 2, rgb(yellow)
        next i
      endif
    case 2
      if type <> 3 then
        text 796, 3, "Word List  " + str$(score) + " of " + str$(num_words),, 5,, rgb(white)
      endif
      if type = 1 then
        for i = 1 to num_words
          text 796, 32 * (i +  1), wordlist$(i),, 5,, rgb(yellow)
        next i
      endif
    case 3
      if type <> 3 then
        text 946, 0, "Word List  " + str$(score) + " of " + str$(num_words),, 3,, rgb(white)
      endif
      if type = 1 then
        for i = 1 to num_words
          text 946, 24 * (i +  1), wordlist$(i),, 3,, rgb(yellow)
        next i
      endif
    case 4
      if type <> 3 then
        text 782, 0, "Word List  " + str$(score) + " of " + str$(num_words),, 2,, rgb(white)
      endif
      if type = 1 then
        for i = 1 to num_words
          if i < 50 then
            text 782, 20 * (i +  1), wordlist$(i),, 2,, rgb(yellow)
          else
            text 1030, 20 * (i - 48), wordlist$(i),, 2,, rgb(red)
          endif
        next i
      endif
    case 5
      if type <> 3 then
        text 855, 0, "Word List  " + str$(score) + " of " + str$(num_words),, 4,, rgb(white)
      endif
      if type = 1 then
        for i = 1 to num_words
          if i < 64 then
            text 855, 16 * (i +  1), wordlist$(i),, 4,, rgb(yellow)
          else
            text 1067, 16 * (i - 62), wordlist$(i),, 4,, rgb(red)
          endif
        next i
      endif
    case 6
      if type <> 3 then  
        text 930, 0, "Word List  " + str$(score) + " of " + str$(num_words),, 1,, rgb(white)
      endif
      if type = 1 then
        for i = 1 to num_words
          if i < 84 then
            text 930, 12 * (i +  1), wordlist$(i),, 1,, rgb(yellow)
          else
            text 1105, 12 * (i - 82), wordlist$(i),, 1,, rgb(red)
          endif
        next i
      endif
    case 7
      if type <> 3 then
        text 880, 0, "Word List  " + str$(score) + " of " + str$(num_words),, 7,, rgb(white)
      endif
      if type = 1 then
        for i = 1 to num_words
          if i < 127 then
            text 880, 8 * (i + 1), wordlist$(i),, 7,, rgb(yellow)
          elseif i > 126 and i < 253 then
            text 1013, 8 * (i - 125), wordlist$(i),, 7,, rgb(red)
          else
            text 1146, 8 * (i - 251), wordlist$(i),, 7,, rgb(cyan)
          endif
        next i
      endif
  end select

  'Display cursor and check for user cursor keys for navigation of grid
  cx = 1 : cy = 1 : ocx = 1 : ocy = 1 : cstate = 0
  select case size
    case 1 : cw = 34 : ch = 49 : csx = sx - 1 : csy = sy - 1 : box csx, csy, cw, ch, 1, rgb(white)
    case 2 : cw = 26 : ch = 33 : csx = sx - 1 : csy = sy - 1 : box csx, csy, cw, ch, 1, rgb(white)
    case 3 : cw = 19 : ch = 24 : csx = sx - 1 : csy = sy - 1 : box csx, csy, cw, ch, 1, rgb(white)
    case 4 : cw = 14 : ch = 22 : csx = sx - 1 : csy = sy - 1 : box csx, csy, cw, ch, 1, rgb(white)
    case 5 : cw = 12 : ch = 17 : csx = sx - 1 : csy = sy - 1 : box csx, csy, cw, ch, 1, rgb(white)
    case 6 : cw = 11 : ch = 15 : csx = sx - 1 : csy = sy - 1 : box csx, csy, cw, ch, 1, rgb(white)
    case 7 : cw =  8 : ch = 10 : csx = sx - 1 : csy = sy - 1 : box csx, csy, cw, ch, 1, rgb(white)
  end select
  do
    if keydown(0) = 1 then 'Only one key pressed
      if keydown(1) = 128 then 'Cursor Up
        if cy > 1 then 'Will we still be on the grid? 
          pause 115
          ocy = cy : inc cy, -1 : ocx = cx 
          'Erase cursor's old position in grid
          box ((ocx - 1) * cw) + csx, ((ocy - 1) * ch) + csy, cw, ch, 1, rgb(black)
          'Display cursor's new position in grid
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white)
        endif
      elseif keydown(1) = 129 then 'Cursor Down
        if cy < gsy then
          pause 115 
          ocy = cy : inc cy : ocx = cx       
          box ((ocx - 1) * cw) + csx, ((ocy - 1) * ch) + csy, cw, ch, 1, rgb(black)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white)
        endif
      elseif keydown(1) = 130 then 'Cursor Left
        if cx > 1 then
          pause 115
          ocx = cx : inc cx, -1 : ocy = cy     
          box ((ocx - 1) * cw) + csx, ((ocy - 1) * ch) + csy, cw, ch, 1, rgb(black)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white)
        endif
      elseif keydown(1) = 131 then 'Cursor Right      
        if cx < gsx then 
          pause 115 'This pause fixed the bug!
          ocx = cx : inc cx : ocy = cy     
          box ((ocx - 1) * cw) + csx, ((ocy - 1) * ch) + csy, cw, ch, 1, rgb(black)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white)         
        endif
      elseif keydown(1) = 32 then 'Space bar
        pause 115
        if gridstate(cx, cy) = 0 then 'Is letter NOT highlighted?
          gridstate(cx, cy) = 1 'Set highlighting to the ON state
          'Set the letter color to White
          text (cx - 1) * cox + sx, (cy - 1) * coy + sy, grid$(cx, cy),,,, rgb(white)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white) 'Redisplay cursor
          found_word_check()
        elseif gridstate(cx, cy) = 1 then 'Is letter highlighted
          gridstate(cx, cy) = 0 'Set highlighting to the OFF state
          'set the letter color to Green
          text (cx - 1) * cox + sx, (cy - 1) * coy + sy, grid$(cx, cy),,,, rgb(green)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white) 'Redisplay cursor      
        endif        
      endif 
    elseif keydown(0) = 2 then 'Two keys pressed simultaneously
      if (keydown(1) = 128 and keydown(2) = 130) or (keydown(1) = 130 and keydown(2) = 128) then 'Cursor Up and Cursor Left pressed
        if cy > 1 and cx > 1 then 'up and left
          pause 115
          ocx = cx : ocy = cy : inc cx, -1 : inc cy, -1
          box ((ocx - 1) * cw) + csx, ((ocy - 1) * ch) + csy, cw, ch, 1, rgb(black)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white)
        endif
      elseif (keydown(1) = 128 and keydown(2) = 131) or (keydown(1) = 131 and keydown(2) = 128) then 'Cursor Down and Cursor Right
        if cy > 1 and cx < gsx then 'up and right
          pause 115 
          ocx = cx : ocy = cy : inc cx : inc cy, -1
          box ((ocx - 1) * cw) + csx, ((ocy - 1) * ch) + csy, cw, ch, 1, rgb(black)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white)
        endif
      elseif (keydown(1) = 129 and keydown(2) = 130) or (keydown(1) = 130 and keydown(2) = 129) then 'Cursor Down and Cursor Left
        if cy < gsy and cx > 1 then 'down and left
          pause 115
          ocx = cx : ocy = cy : inc cx, -1 : inc cy 
          box ((ocx - 1) * cw) + csx, ((ocy - 1) * ch) + csy, cw, ch, 1, rgb(black)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white)
        endif
      elseif (keydown(1) = 129 and keydown(2) = 131) or (keydown(1) = 131 and keydown(2) = 129) then 'Cursor Down and Cursor Right      
        if cy < gsy and cx < gsx then 'This is down right tedious
          pause 115
          ocx = cx : ocy = cy : inc cx : inc cy
          box ((ocx - 1) * cw) + csx, ((ocy - 1) * ch) + csy, cw, ch, 1, rgb(black)
          box ((cx - 1) * cw) + csx, ((cy - 1) * ch) + csy, cw, ch, 1, rgb(white)         
        endif
      endif
    endif   
  loop
end sub

sub display_word_list_line()
  select case size
    case 1
      text 672, 3, "Word List " + str$(score) + " of " + str$(num_words),, 3, 2, rgb(white)
    case 2
      text 796, 3, "Word List  " + str$(score) + " of " + str$(num_words),, 5,, rgb(white)
    case 3
      text 946, 0, "Word List  " + str$(score) + " of " + str$(num_words),, 3,, rgb(white)
    case 4
      text 782, 0, "Word List  " + str$(score) + " of " + str$(num_words),, 2,, rgb(white)
    case 5
      text 855, 0, "Word List  " + str$(score) + " of " + str$(num_words),, 4,, rgb(white)
    case 6
      text 930, 0, "Word List  " + str$(score) + " of " + str$(num_words),, 1,, rgb(white)
    case 7
      text 880, 0, "Word List  " + str$(score) + " of " + str$(num_words),, 7,, rgb(white)
  end select
end sub

sub found_word_check()  
  for z = 1 to 4
    ghc = 0
    if gridhit(cx, cy, z) > 0 then 'Is the letter last highlighted part of a word in the word list?
      h = gridhit(cx, cy, z)
      letter_count = 0
      do
        for i = 1 to gsx
          for j = 1 to gsy
            if (gridhit(i, j, 1) = h or gridhit(i, j, 2) = h or gridhit(i, j, 3) = h or gridhit(i, j, 4) = h) and gridstate(i, j) <> 0 then
              inc letter_count
              inc ghc
              gridstate(i, j) = 2 'LOCK down this letter so that user cannot unhighlight it
            elseif gridhit(i, j, z) = h and gridstate(i, j) = 0 then
              inc ghc
              exit do
            endif
            if ghc = len(wordlist$(h)) then exit do   
          next j
        next i
        exit do
      loop 
      if letter_count = len(wordlist$(h)) then 'Has user found the word?
        if type = 1 then
          'Delete the displayed word in the word list and subtract from remaning words (score)
          select case size
            case 1
              text 672, 48 * (h + 1), "                    ",, 3, 2, rgb(black)
            case 2
              text 796, 32 * (h + 1), "                    ",, 5,, rgb(black) 
            case 3
              text 946, 24 * (h + 1), "                    ",, 3,, rgb(black)        
            case 4
              if h < 50 then
                text 782, 20 * (h + 1), "                    ",, 2,, rgb(black)
              else 'h > 49
                text 1030, 20 * (h - 48), "                    ",, 2,, rgb(black)
              endif
            case 5
              if h < 64 then
                text 855, 16 * (h + 1), "                    ",, 4,, rgb(black)
              else 'h > 63
                text 1057, 16 * (h - 62), "                    ",, 4,, rgb(black)
              endif
            case 6
              if h < 84 then
                text 930, 12 * (h + 1), "                    ",, 1,, rgb(black)
              else 'h > 83
                text 1105, 12 * (h - 82), "                    ",, 1,, rgb(black)
              endif
            case 7
              if h < 127 then
                text 880, 8 * (h + 1), "                    ",, 7,, rgb(black)
              elseif h > 126 and h < 253 then
                text 1013, 8 * (h - 125), "                    ",, 7,, rgb(black)
              else 'h > 252
                text 1146, 8 * (h - 251), "                    ",, 7,, rgb(black)
              endif
          end select
          inc score, -1
          display_word_list_line()
        elseif type = 2 then
          'Display the found word in the word list
          select case size
            case 1  
              text 672, 32 * (h + 1), wordlist$(h),, 3, 2, rgb(yellow)
            case 2
              text 796, 32 * (h + 1), wordlist$(h),, 5,, rgb(yellow) 
            case 3
              text 946, 24 * (h + 1), wordlist$(h),, 3,, rgb(yellow)        
            case 4
              if h < 50 then
                text 782, 20 * (h + 1), wordlist$(h),, 2,, rgb(yellow)
              else 'h > 49
                text 1030, 20 * (h - 48), wordlist$(h),, 2,, rgb(red)
              endif
            case 5
              if h < 64 then
                text 855, 16 * (h + 1), wordlist$(h),, 4,, rgb(yellow)
              else 'h > 63
                text 1057, 16 * (h - 62), wordlist$(h),, 4,, rgb(red)
              endif
            case 6
              if h < 84 then
                text 930, 12 * (h + 1), wordlist$(h),, 1,, rgb(yellow)
              else 'h > 83
                text 1105, 12 * (h - 82), wordlist$(h),, 1,, rgb(red)
              endif
            case 7
              if h < 127 then
                text 880, 8 * (h + 1), wordlist$(h),, 7,, rgb(yellow)
              elseif h > 126 and h < 253 then
                text 1013, 8 * (h - 125), wordlist$(h),, 7,, rgb(red)
              else 'h > 252
                text 1146, 8 * (h - 251), wordlist$(h),, 7,, rgb(cyan)
              endif
          end select
          inc score, -1
          display_word_list_line()
        elseif type = 3 then
          inc score
          display_score()        
        endif
      endif     
    endif
  next z
end sub

'Display number of words found for game type 3
sub display_score
  if type = 3 then
    if score > 99 then 
      score3$ = left$(str$(score), 1)
      score2$ = mid$(str$(score), 1, 1)
      score1$ = right$(str$(score), 1)
    elseif score > 9 then
      score3$ = ""
      score2$ = left$(str$(score), 1)
      score1$ = right$(str$(score), 1)
    else
      score3$ = ""
      score2$ = ""
      score1$ = str$(score)
    endif  
    select case size
      case 1    
        text 1240,   0, score2$,, 3, 2, rgb(orange)
        text 1240,  48, score1$,, 3, 2, rgb(orange)
        text 1240, 144, "o",, 3, 2, rgb(orange)
        text 1240, 192, "f",, 3, 2, rgb(orange)
        text 1240, 288, "4",, 3, 2, rgb(orange) 
        text 1240, 336, "8",, 3, 2, rgb(orange)
      case 2
        text 1258,   0, score2$,, 5,, rgb(orange)
        text 1258,  32, score1$,, 5,, rgb(orange)
        text 1258,  96, "o",, 5,, rgb(orange)
        text 1258, 128, "f",, 5,, rgb(orange)
        text 1258, 192, "7",, 5,, rgb(orange) 
        text 1258, 224, "2",, 5,, rgb(orange)
      case 3
        text 1261,   0, score3$,, 3,, rgb(orange)
        text 1261,  24, score2$,, 3,, rgb(orange)
        text 1261,  48, score1$,, 3,, rgb(orange)
        text 1261,  96, "o",, 3,, rgb(orange)
        text 1261, 120, "f",, 3,, rgb(orange)
        text 1261, 168, "1",, 3,, rgb(orange) 
        text 1261, 192, "2",, 3,, rgb(orange)
        text 1261, 216, "0",, 3,, rgb(orange)
      case 4
        text 1266,   0, score3$,, 2,, rgb(orange)
        text 1266,  20, score2$,, 2,, rgb(orange)
        text 1266,  40, score1$,, 2,, rgb(orange)
        text 1266,  80, "o",, 2,, rgb(orange)
        text 1266, 100, "f",, 2,, rgb(orange)
        text 1266, 140, "2",, 2,, rgb(orange)
        text 1266, 160, "0",, 2,, rgb(orange) 
        text 1266, 180, "0",, 2,, rgb(orange)
      case 5
        text 1267,   0, score3$,, 4,, rgb(orange)
        text 1267,  16, score2$,, 4,, rgb(orange)
        text 1267,  32, score1$,, 4,, rgb(orange)
        text 1267,  64, "o",, 4,, rgb(orange)
        text 1267,  80, "f",, 4,, rgb(orange)
        text 1267, 112, "3",, 4,, rgb(orange)
        text 1267, 128, "6",, 4,, rgb(orange) 
        text 1267, 144, "0",, 4,, rgb(orange)
      case 6
        text 1269,   0, score3$,, 1,, rgb(orange)
        text 1269,  12, score2$,, 1,, rgb(orange)
        text 1269,  24, score1$,, 1,, rgb(orange)
        text 1269,  48, "o",, 1,, rgb(orange)
        text 1269,  60, "f",, 1,, rgb(orange)
        text 1269,  84, "5",, 1,, rgb(orange)
        text 1269,  96, "2",, 1,, rgb(orange) 
        text 1269, 108, "0",, 1,, rgb(orange)
      case 7
        text 1270,   0, score3$,, 7,, rgb(orange)
        text 1270,  10, score2$,, 7,, rgb(orange)
        text 1270,  20, score1$,, 7,, rgb(orange)
        text 1270,  40, "o",, 7,, rgb(orange)
        text 1270,  50, "f",, 7,, rgb(orange)
        text 1270,  70, "8",, 7,, rgb(orange)
        text 1270,  80, "0",, 7,, rgb(orange) 
        text 1270,  90, "0",, 7,, rgb(orange)
    end select
  endif
end sub

do : loop


